# YouTube AdBlocker

This repository contains an extension designed to block irritating ads on YouTube, providing users with a seamless and uninterrupted viewing experience. Enhance your time on YouTube by eliminating unwanted interruptions.

- [YouTube AdBlocker](#youtube-adblocker)
  - [Installation Steps](#installation-steps)
    - [Chrome](#chrome)
    - [Microsoft Edge](#microsoft-edge)
    - [Mozilla Firefox](#mozilla-firefox)
  - [To-Do List](#to-do-list)
  - [Star History](#star-history)
  - [Contributors](#contributors)

## Installation Steps

- [Download Youtube AdBlocker Latest Release zip](https://github.com/kananinirav/Youtube-AdBlocker/archive/refs/tags/v3.2.0.zip) or clone this repository.
- If the downloaded file is a ZIP archive, extract its contents to a folder using a tool like WinRAR or 7-Zip.

### Chrome

- Type `chrome://extensions/` in the address bar of Chrome and press Enter.
- Enable Developer mode: Toggle the `Developer mode` switch at the top right of the Extensions page.
- Load the extension: Click on the `Load unpacked` button and select the folder where you extracted the extension files or drag the folder.
- Confirm installation: Confirm that the extension is now listed on the Extensions page and is enabled.
- Check functionality on YouTube: Open YouTube in a new tab and verify whether the extension is working as expected.

### Microsoft Edge

- Access Extensions Menu: Click on the three horizontal dots in the upper-right corner to open the menu and select `Extensions` from the menu.
- Enable Developer Mode: Scroll down on the Extensions page and find the `Developer mode` toggle switch.
Turn on Developer mode.
- Load the Extension: Click on the `Load unpacked` button that appears after enabling Developer mode. Navigate to the folder where the extension files are located and select the extension's folder or drag the folder.
- Confirm Installation: Confirm that the extension is now listed on the Extensions page and is enabled.
- Open a new tab and check whether the extension is working as expected.

### Mozilla Firefox

- Direct Install from store: <https://addons.mozilla.org/en-GB/firefox/addon/youtube-adblocker-free/>

--------------------------------------- Or ---------------------------------------

- Access the Add-ons (Extensions) Manager:
  - Click on the three horizontal lines in the upper-right corner to open the menu.
  - Select "Add-ons" from the menu.
- Enable Developer Mode:
  - In the Add-ons Manager, click on the gear icon (settings) in the top right corner.
  - Choose `Debug Add-ons.`
  - Turn on the `Enable add-on debugging` and `Enable extension debugging` options.
- Load the Extension:
  - Click on `Load Temporary Add-on` or `Load Add-on From File,` depending on your Firefox version.
  - Navigate to the folder where the extension files are located and select the extension's `manifest.json` file
- Manage Extension Settings:
  - In the Add-ons Manager, click on the three horizontal dots next to the extension you installed.
Choose `Manage`
  - Under `Permissions`, enable (`*://youtube.com, *://www.youtube.com, *://m.youtube.com`) toggle button
- Confirm Installation: Confirm that the extension is listed on the Add-ons Manager page and is enabled.
- Open a new tab and check whether the extension is working as expected.

I've confirmed the installation steps provided above and the extension works seamlessly. It effectively blocks YouTube ads and prevents ad-blocker detection popups, ensuring an uninterrupted and ad-free browsing experience.

**If you find this helpful, please give a star to this repository and share it with your friends. Your support is greatly appreciated!**

## To-Do List

Implement a toggle button feature for enabling or disabling the extension.

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=kananinirav/Youtube-AdBlocker&type=Date)](https://star-history.com/#kananinirav/Youtube-AdBlocker&Date)

## Contributors

Please Feel free to contribute by submitting a Pull Request!

[![](https://contrib.rocks/image?repo=kananinirav/Youtube-AdBlocker)](https://github.com/kananinirav/Youtube-AdBlocker/graphs/contributors)

**If you find this extension useful, consider supporting the project by using the "Buy me a Coffee" link below**

![gif](https://media.giphy.com/media/gTURHJs4e2Ies/giphy.gif)

<a href="https://www.buymeacoffee.com/kananinirav" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/default-orange.png" alt="Buy Me A Coffee" height="41" width="174"></a>
